global.prefillFields = function (btn) {
	const fieldset = btn ? btn.closest('fieldset') : null;

	if (!fieldset) {
		return;
	}

	fieldset.querySelectorAll('[data-field-default]').forEach(el => {
		el.value = el.dataset.fieldDefault;
		el.dispatchEvent(new Event('change'));
	});

	fieldset.querySelectorAll('[data-field-default-editor]').forEach(el => {
		const inputWrap = el.closest('.frm__pair');
		if (!inputWrap) {
			return;
		}

		inputWrap.querySelectorAll('textarea[data-content-lang="' + el.dataset.contentLang + '"]').forEach(textarea => {
			try {
				el.value           = el.dataset.fieldDefaultEditor;
				textarea.innerText = el.dataset.fieldDefaultEditor;

				const editor = CKEDITOR.instances[textarea.id];

				if (editor) {
					editor.setData(el.dataset.fieldDefaultEditor);
				}
			} catch (e) {
			}
		})
	});
}
