<?php declare(strict_types = 1);

namespace Forms\AdminModule\Presenters;

use Forms\AdminModule\Components\FormsGrid;
use Forms\AdminModule\Components\IFormsGridFactory;
use Forms\Model\FormsConfig;

class DefaultPresenter extends BasePresenter
{
	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		$this->setHeader('forms.title.forms', 'fab fa-wpforms');
		$data = [
			[
				'title' => 'forms.menu.newForm',
				'link'  => $this->link('formsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		];

		if (FormsConfig::load('enableKeywordCaptcha')) {
			$data[] = [
				'title' => 'forms.menu.disallowedKeywords',
				'link'  => 'DisallowedKeywords:default',
				'ico'   => 'fas fa-key',
			];
		}
		$this['navigation']->setData(['header' => $data]);
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentFormsGrid(IFormsGridFactory $factory): FormsGrid
	{
		return $factory->create();
	}

}
