<?php declare(strict_types = 1);

namespace Forms\FrontModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Forms\FrontModule\Model\Dao;
use Forms\Model\Entities\Form;
use Forms\Model\FormsCache;
use Nette\Caching\Cache;
use Throwable;

class Forms extends BaseEntityService
{
	protected       $entityClass = Form::class;
	protected array $cForms      = [];

	public function __construct(protected FormsCache $formsCache)
	{
	}

	/**
	 * @param int|string $id
	 */
	public function get($id): ?Form
	{
		if (!isset($this->cForms[$id])) {
			if (is_numeric($id)) {
				$this->cForms[$id] = parent::get($id);
			} else {
				$this->cForms[$id] = $this->getEr()->findOneBy(['ident' => $id]);
			}
		}

		return $this->cForms[$id];
	}

	/**
	 * @throws Throwable
	 */
	public function getBasicData(int|string $id): ?Dao\Form
	{
		return $this->formsCache->getCache()->load('form_' . $id, function(&$dep) use ($id) {
			$dep = [
				Cache::Tags       => 'form',
				Cache::Expire => '1 week',
			];

			$entity = $this->get($id);

			return $entity ? Dao\Form::fromEntity($entity) : null;
		});
	}

}
