<?php declare(strict_types = 1);

namespace Forms\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'forms__form_text')]
#[ORM\Entity]
class FormText
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Form::class, inversedBy: 'texts')]
	#[ORM\JoinColumn(name: 'form_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public Form $form;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2, nullable: true)]
	public ?string $lang = null;

	#[ORM\Column(type: Types::STRING, length: 255)]
	public string $title;

	#[ORM\Column(type: Types::STRING, length: 255)]
	public string $userEmailSubject;

	#[ORM\Column(type: Types::STRING, length: 255)]
	public string $adminEmailSubject;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $userEmailContent = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $userEmailConfirm = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $adminEmailContent = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $messageAfterSend = null;

	public function __construct(Form $form, string $lang, string $title)
	{
		$this->form  = $form;
		$this->lang  = $lang;
		$this->title = $title;
	}

}
