<?php declare(strict_types = 1);

namespace Forms\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'forms__submission_field')]
#[ORM\Entity]
class SubmissionField
{
	use TId;

	#[ORM\ManyToOne(targetEntity: Field::class)]
	#[ORM\JoinColumn(name: 'field_id', referencedColumnName: 'id', nullable: true, onDelete: 'CASCADE')]
	public ?Field $field = null;

	#[ORM\ManyToOne(targetEntity: Submission::class, cascade: ['persist'], inversedBy: 'fields')]
	#[ORM\JoinColumn(name: 'submission_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public Submission $submission;

	#[ORM\Column(name: 'name', type: Types::STRING)]
	public string $name;

	#[ORM\Column(name: 'value', type: Types::TEXT)]
	public string $value;

	public function __construct(Submission $submission, string $name, string $value)
	{
		$this->submission = $submission;
		$this->name       = $name;
		$this->value      = $value;
	}

}
