<?php declare(strict_types = 1);

namespace Forms\Model\Subscribers;

use Core\Model\Event\CreateFormEvent;
use Core\Model\SystemConfig;
use Forms\FrontModule\Components\FormControl;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class DefaultFormControlSubscriber implements EventSubscriberInterface
{
	public static function getSubscribedEvents(): array
	{
		return [
			FormControl::class . '::createDefaultContact' => 'defaultContact',
		];
	}

	public function defaultContact(CreateFormEvent $event): void
	{
		$form = &$event->form;
		$form->setAjax();

		$form->addText('name', 'formsFront.defaultContact.name')->setRequired();
		$form->addEmail('email', 'formsFront.defaultContact.email')->setRequired();
		$form->addText('phone', 'formsFront.defaultContact.phone');
		$form->addTextArea('message', 'formsFront.defaultContact.message')->setRequired();

		$form->addCheckbox('gdprAgree', 'formsFront.defaultContact.gdprAgree')->setRequired();


		if (SystemConfig::load('useGoogleRecaptcha') === true) {
			if (SystemConfig::load('googleRecaptchaInvisible') === true) {
				$form->addInvisibleReCaptcha('recaptcha', true, 'formsFront.defaultContact.recaptcha')
					->setRequired('default.formMessages.recaptchaBadResponse');
			} else {
				$form->addReCaptcha('recaptcha', 'Google recaptcha', true, 'formsFront.defaultContact.recaptcha')
					->setRequired('default.formMessages.recaptchaRequired');
			}
		}

		$form->addSubmit('submit', 'formsFront.defaultContact.submit');
	}

}
