<?php declare(strict_types = 1);

namespace Forms\Model\TemplateTextType;

use Contributte\Translation\Translator;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use Forms\AdminModule\Model\Forms as AdminForms;
use Forms\FrontModule\Model\Forms as FrontForms;
use InvalidArgumentException;

class Forms extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'form';

	public function __construct(
		protected FrontForms $forms,
		protected AdminForms $adminForms,
		protected Translator $translator,
	)
	{
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$formContainer->addSelect(
			$this->getName(),
			$this->getTitle(),
			[null => ''] + $this->adminForms->getOptionsForSelect(),
		);
	}

	public function render(array $params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->getDefault() ? (int) $this->getDefault() : null;
	}
}
