<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Components\Album;

use Core\Components\Flashes\Flashes;
use Core\Model\Images\TImagePipe;
use Core\Model\UI\BaseControl;
use Gallery\Model\Albums;

/**
 * TODO stránkování
 *
 * Class AlbumsList
 * @package Gallery\AdminModule\Components
 */
class AlbumsList extends BaseControl
{

	/** @var int */
	protected $page = 1;

	/** @var Albums */
	protected $albumsService;

	public function __construct(Albums $albums)
	{
		$this->albumsService = $albums;
	}

	public function render()
	{
		$limit                      = 12;
		$this->template->page       = $this->page;
		$this->template->pagesCount = floor($this->albumsService->getCount() / $limit);
		$this->template->albums     = $this->albumsService->getAlbums($limit, ($this->page - 1) * $limit);
		$this->template->render(__DIR__ . '/AlbumsList.latte');
	}

	/*******************************************************************************************************************
	 * ========================  Handle
	 */

	public function handleDeleteAlbum($id)
	{
		$presenter = $this->getPresenter();
		$error     = false;

		try {
			if ($result = $this->albumsService->deleteAlbum($id)) {
				$presenter->flashMessage('gallery.album.deleteSuccess', Flashes::FLASH_SUCCESS);
			} else {
				$error = true;
			}
		} catch (\Exception $e) {
			$presenter->flashMessage($e->getMessage(), Flashes::FLASH_DANGER);
			$error = true;
		}

		if ($presenter->isAjax()) {
			$presenter->redrawControl('flashes');

			if (!$error)
				$this->redrawControl('albumsList');
		} else {
			$this->redirect('this');
		}
	}

	public function handlePage($page)
	{
		$this->page = $page;
	}
}
