<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Components\Image;

use Core\Model\UI\BaseControl;
use Gallery\Model\Albums;
use Gallery\Model\Images;

class ImagesPicker extends BaseControl
{
	/** @var Images */
	protected $imagesService;

	/** @var Albums */
	protected $albumsService;

	/** @var Images[] */
	protected $images;

	public function __construct(Images $images, Albums $albums)
	{
		$this->imagesService = $images;
		$this->albumsService = $albums;
	}

	public function render()
	{
		$this->template->images = $this->images;
		$this->template->render(__DIR__ . '/ImagesPicker.latte');
	}

	public function setByAlbum($id)
	{
		$images = [];

		foreach ($this->imagesService->getByAlbum($id) as $image)
			$images[] = $image;

		$this->images = $images;
	}
}
