<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Presenters;

use Gallery\AdminModule\Components\IAlbumForm;
use Gallery\AdminModule\Components\Album\IAlbumFormFactory;
use Gallery\AdminModule\Components\Album\IAlbumsListFactory;
use Gallery\Model\Entities\Album;
use Nette\Http\IResponse;
use Nette\Utils\Html;

final class DefaultPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('gallery.title.gallery'));
		$this->setHeader('gallery.title.gallery', 'fa fa-image');
	}

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'gallery.menu.newGallery',
				'link'  => 'Default:add',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAdd()
	{
		$this->setTitle($this->translator->translate('gallery.title.newGallery'));
		$this->setHeader('gallery.title.newGallery', 'fa fa-image');
	}

	public function actionEdit($id)
	{
		$album = $this->em->getRepository(Album::class)->find($id);

		if (!$album)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('gallery.title.editGallery') . ': ' . Html::el('span class=font-weight-light')->setText($album->title));
		$this->setHeader('gallery.title.editGallery', 'fa fa-image');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentAlbumForm(IAlbumFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setAlbum($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentAlbumsList(IAlbumsListFactory $factory)
	{
		return $factory->create();
	}
}