<?php declare(strict_types = 1);

namespace Gallery\DI;

use Core\DI\CompilerExtension;
use Nette;

class GalleryExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		Nette\DI\Compiler::loadDefinitions(
			$this->getContainerBuilder(),
			$this->loadFromFile(__DIR__ . '/services.neon')
		);
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Gallery' => 'Gallery\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();
		$builder->getDefinition('nette.latteFactory')
			->addSetup('addProvider', ['imagesService', $builder->getDefinition('gallery.front.images')]);
	}
}