<?php declare(strict_types = 1);

namespace Gallery\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Gallery\Model\Entities\Album;
use Nette\Caching\Cache;

/**
 * Class Albums
 * @package Gallery\FrontModule\Model
 */
class Albums extends BaseFrontEntityService
{
	const CACHE_NAMESPACE = 'albums';

	protected $entityClass = Album::class;

	public function get($id)
	{
		$albums = $this->getEr()->createQueryBuilder('a', 'a.id')
			->andWhere(is_array($id) ? 'a.id IN (:id)' : 'a.id = :id')->setParameter('id', $id)
			->andWhere('a.isPublished = 1')
			->getQuery();

		return is_array($id) ? $albums->getResult() : $albums->getOneOrNullResult();
	}
}