<?php declare(strict_types = 1);

namespace Gallery\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Gallery\Model\Entities\Image;

/**
 * Class Images
 * @package Gallery\FrontModule\Model
 */
class Images extends BaseFrontEntityService
{
	const CACHE_NAMESPACE = 'images';

	protected $entityClass = Image::class;

	public function getCoverImage($albumId)
	{
		if (!$albumId)
			return null;

		$r = $this->getEr()->createQueryBuilder('i')->where('i.isCover = 1 OR i.position = 0')
			->join('i.album', 'a')->andWhere('a.id = :albumId')->setParameter('albumId', $albumId)
			->getQuery()->useResultCache(true, 60)->getResult();

		foreach ($r as $i) {
			if ($i->isCover)
				return $i;
		}

		return $r ? $r[0] : null;
	}
}