<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Gallery\Model\Albums;
use Kdyby\Events\Subscriber;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;

class AlbumListener implements Subscriber
{
	use SmartObject;

	/** @var */
	private $cache;

	public function __construct(IStorage $cacheStorage)
	{
		$this->cache = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param Album              $album
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($album, $args)
	{
		if ($album->getId())
			$this->cache->clean([
				Cache::TAGS => [Albums::CACHE_NAMESPACE . '/' . $album->getId()],
			]);
		else {
			$this->cache->clean([
				Cache::TAGS => [Albums::CACHE_NAMESPACE],
			]);
		}
	}

}