<?php declare(strict_types = 1);

namespace Gallery\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\UI\Form\BaseContainer;
use Gallery\Model\Albums;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Gallery extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'gallery';

	/** @var Albums */
	protected $albumsService;

	public function __construct(Albums $albums)
	{
		$this->albumsService = $albums;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$formContainer->addGalleryPopup($this->getName(), $this->getTitle());
	}

	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->getDefault() ? $this->albumsService->getPublishedById($this->getDefault()) : null;
	}
}