<?php declare(strict_types = 1);

namespace Gallery\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

class Album
{
	use MagicAccessors;

	/** @var int */
	public $id;

	/** @var string */
	public $title;

	/** @var string */
	public $description;

	/** @var Image[] */
	protected $images;

	/** @var Image */
	protected $cover;

	/**
	 * @param Image[] $images
	 *
	 * @return $this
	 */
	public function setImages(array $images)
	{
		$this->images = [];
		foreach ($images as $img) {
			if ($img instanceof Image)
				$this->images[] = $img;
		}

		return $this;
	}

	/**
	 * @param Image $image
	 *
	 * @return $this
	 */
	public function addImage(Image $image)
	{
		$this->images[] = $image;

		return $this;
	}

	/**
	 * @param Image $img
	 *
	 * @return $this
	 */
	public function setCover(Image $img)
	{
		$this->cover = $img;

		return $this;
	}

	/**
	 * @return Image[]
	 */
	public function getImages()
	{
		return $this->images;
	}
}
