<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class ImageText
 * @package Gallery\Model\Entities
 *
 * @ORM\Table(name="gallery__image_text")
 * @ORM\Entity
 * @ORM\EntityListeners({"ImageTextListener"})
 */
class ImageText
{
	use MagicAccessors;

	/**
	 * @var Image
	 *
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Image", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="image_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $image;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2)
	 */
	private $lang;

	/**
	 * @var string
	 * @ORM\Column(name="source", type="string", length=255, nullable=true)
	 */
	public $source;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="text", nullable=true)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="description", type="text", nullable=true)
	 */
	public $description;

	/**
	 * @var string
	 * @ORM\Column(name="link", type="string", length=255, nullable=true)
	 */
	public $link;

	/**
	 * ImageText constructor.
	 *
	 * @param Image  $image
	 * @param string $lang
	 */
	public function __construct($image, $lang)
	{
		$this->image = $image;
		$this->lang  = $lang;
	}

	public function getImage() { return $this->image; }

	public function getLang() { return $this->lang; }
}
