<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Components\Album;

use Core\Model\UI\BaseControl;
use Gallery\AdminModule\Model\Albums;

class AlbumsList extends BaseControl
{
	protected int $page = 1;

	protected Albums $albumsService;

	public function __construct(Albums $albums)
	{
		$this->albumsService = $albums;
	}

	public function render(): void
	{
		$limit                      = 12;
		$this->template->page       = $this->page;
		$this->template->pagesCount = ceil($this->albumsService->getCount() / $limit);
		$this->template->albums     = $this->albumsService->getAlbums($limit, ($this->page - 1) * $limit);

		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ========================  Handle
	 */

	public function handleDeleteAlbum(int $id): void
	{
		$presenter = $this->getPresenter();
		$error     = false;

		try {
			if ($result = $this->albumsService->deleteAlbum($id))
				$presenter->flashMessageSuccess('gallery.album.deleteSuccess');
			else
				$error = true;
		} catch (\Exception $e) {
			$presenter->flashMessageDanger($e->getMessage());
			$error = true;
		}

		$presenter->redrawControl('flashes');
		if (!$error)
			$this->redrawControl('albumsList');
	}

	public function handlePage(int $page): void
	{
		$this->page = $page;
	}
}
