<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Components\Image;

use Core\Model\UI\BaseControl;
use Gallery\Model\Entities\Album;
use Gallery\Model\Images;

class ImageFinder extends BaseControl
{
	/** @var Images */
	protected $imagesService;

	/** @var Album */
	protected $activeAlbum;

	/** @var callable */
	public $onUseImage = [];

	public function __construct(Images $images)
	{
		$this->imagesService = $images;
	}

	public function render()
	{
		$this->template->activeImagesId = $this->activeAlbum ? array_map(function($i) { return $i->getId(); }, $this->activeAlbum->getImages()->toArray()) : [];
		$this->template->render(__DIR__ . '/ImageFinder.latte');
	}

	/*******************************************************************************************************************
	 * =================  Handle
	 */

	public function handleSearch($q)
	{
		$this->template->images = $this->imagesService->search($q);
		$this->redrawControl('results');
	}

	/*******************************************************************************************************************
	 * =================  Get / Set
	 */

	/**
	 * @param Album $album
	 */
	public function setActiveAlbum(Album $album)
	{
		$this->activeAlbum = $album;
	}
}
