<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Query;
use Gallery\Model\Entities\Album;
use Gallery\Model\Entities\AlbumText;
use Gallery\Model\Entities\Image;

/**
 * Class Albums
 * @package Blog\Model
 *
 * @method Album|null|object = getReference($id)
 * @method Album[]|null getAll()
 * @method Album|null get($id)
 */
class Albums extends BaseEntityService
{
	const CACHE_NAMESPACE = 'albums';

	protected $entityClass = Album::class;

	public function getCount() { return $this->getEr()->count([]); }

	/**
	 * @param $limit
	 * @param $offset
	 *
	 * @return Album[]
	 */
	public function getAlbums($limit = null, $offset = null)
	{
		$qb = $this->getEr()->createQueryBuilder('a')->select('a.id')->orderBy('a.id', 'DESC');

		if ($limit != null)
			$qb->setMaxResults($limit);
		if ($offset != null)
			$qb->setFirstResult($offset);

		$result = $qb->getQuery()->getResult();
		$ids    = array_map(function($a) { return $a['id']; }, $result);

		$albums = [];
		foreach ($ids as $id)
			$albums[$id] = $this->getAlbum($id);

		return $albums;
	}

	/**
	 * @param $id
	 *
	 * @return null|Album
	 */
	public function getAlbum($id)
	{
		$qb = $this->getEr()->createQueryBuilder('a')
			->addSelect('at, i, it')
			->leftJoin('a.texts', 'at')
			->leftJoin('a.images', 'i')
			->leftJoin('i.texts', 'it')
			->where('a.id = :album')->setParameter('album', $id);

		return $qb->getQuery()->getOneOrNullResult();
	}

	public function deleteAlbum(int $id): bool
	{
		if ($album = $this->getEr()->find($id)) {
			/** @var Album $album */
			if ($album->getImagesCount() != 0)
				throw new \Exception('gallery.album.cannotDeleteContainsImages');

			$this->em->remove($album);
			$this->em->flush();

			return true;
		}

		return false;
	}
}
