<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use Gallery\AdminModule\Components\IAlbumForm;
use Gallery\AdminModule\Components\Album\IAlbumFormFactory;
use Gallery\AdminModule\Components\Album\IAlbumsListFactory;
use Gallery\AdminModule\Model\Albums;
use Gallery\Model\Entities\Album;
use Nette\Http\IResponse;
use Nette\Utils\Html;

final class DefaultPresenter extends BasePresenter
{
	/** @var Albums @inject */
	public $albumsService;

	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('gallery.title.gallery'));
		$this->setHeader('gallery.title.gallery', 'fa fa-image');
	}

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'gallery.menu.newGallery',
				'link'  => 'Default:add',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAdd()
	{
		$this->setTitle($this->translator->translate('gallery.title.newGallery'));
		$this->setHeader('gallery.title.newGallery', 'fa fa-image');
	}

	public function actionEdit($id)
	{
		$album = $this->albumsService->getAlbum($id);

		if (!$album)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('gallery.title.editGallery') . ': ' . Html::el('span class=font-weight-light')->setText($album->getText()->title));
		$this->setHeader('gallery.title.editGallery', 'fa fa-image');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentAlbumForm(IAlbumFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setAlbum($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('edit', $form->getCustomData('albumId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentAlbumsList(IAlbumsListFactory $factory)
	{
		return $factory->create();
	}
}
