<?php declare(strict_types = 1);

namespace Gallery\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Doctrine\Common\Collections\Criteria;
use Gallery\FrontModule\Model\Albums;
use Gallery\Model\Entities\Album;
use Gallery\Model\Images;
use Nette\Caching\IStorage;

class GalleryControl extends BaseControl
{
	/** @var Images */
	protected $imagesService;

	/** @var Albums */
	protected $albumsService;

	/** @var Album */
	protected $album;

	/** @var string */
	public $templateFile = __DIR__ . '/default.latte';

	public function __construct(Images $images, Albums $albums)
	{
		$this->imagesService = $images;
		$this->albumsService = $albums;
	}

	public function render()
	{
		if (!$this->album)
			return '';

		$this->template->album = $this->album;
		$this->template->render($this->getTemplateFile());
	}

	public function setAlbum($id)
	{
		$this->album = $this->albumsService->get($id);

		return $this;
	}

	/*******************************************************************************************************************
	 * ============================== Handle
	 */
}
