<?php declare(strict_types = 1);

namespace Gallery\Model;

use Core\Model\Helpers\BaseEntityService;
use Gallery\Model\Entities\Album;
use Nette\Caching\Cache;

/**
 * Class Albums
 * @package Blog\Model
 *
 * @method Album|null|object = getReference($id)
 * @method Album[]|null getAll()
 * @method Album|null get($id)
 */
class Albums extends BaseEntityService
{
	const CACHE_NAMESPACE = 'albums';

	protected $entityClass = Album::class;

	/**
	 * Get published by ID(s)
	 *
	 * @param $id
	 *
	 * @return mixed
	 */
	public function getPublishedById($id)
	{
		$albums = $this->getEr()->createQueryBuilder('a', 'a.id')
			->andWhere(is_array($id) ? 'a.id IN (:id)' : 'a.id = :id')->setParameter('id', $id)
			->andWhere('a.isPublished = 1')
			->getQuery();

		return is_array($id) ? $albums->getResult() : $albums->getOneOrNullResult();
	}

	private function getCache()
	{
		if ($this->cache === null)
			$this->cache = new Cache($this->cacheStorage, self::CACHE_NAMESPACE);

		return $this->cache;
	}

	public function getCount() { return $this->getEr()->count([]); }

	/**
	 * @param $limit
	 * @param $offset
	 *
	 * @return Album[]
	 */
	public function getAlbums($limit = null, $offset = null)
	{
		$qb = $this->getEr()->createQueryBuilder('a')->orderBy('a.id', 'DESC');

		if ($limit != null)
			$qb->setMaxResults($limit);
		if ($offset != null)
			$qb->setFirstResult($offset);

		return $qb->getQuery()->getResult();
	}

	/**
	 * @param $id
	 *
	 * @return null|Album
	 */
	public function getAlbum($id)
	{
		return $this->getEr()->find($id);
		//		$key = self::CACHE_NAMESPACE . '/' . $id;
		//
		//		return $this->getCache()->load($key, function(&$dep) use ($key, $id) {
		//			$dep = [Cache::TAGS => [self::CACHE_NAMESPACE, $key]];
		//
		//			$album->getImages();
		//
		//			return $album;
		//		});
	}

	/**
	 * @param $id
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function deleteAlbum($id)
	{
		if ($album = $this->getEr()->find($id)) {
			/** @var Album $album */

			if ($album->getImagesCount() != 0)
				throw new \Exception('gallery.album.cannotDeleteContainsImages');

			$this->em->remove($album);
			$this->em->flush();

			return true;
		}

		return false;
	}
}