<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;
use Nette\Utils\Strings;

/**
 * TODO odstranit texty v této entitě
 *
 * @ORM\Table(name="gallery__album")
 * @ORM\Entity
 * @ORM\EntityListeners({"AlbumListener", "Core\Model\Entities\TranslateListener"})
 */
class Album
{
	use TId;
	use TTranslateListener;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=true)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="description", type="text", nullable=true)
	 */
	protected $description;

	/**
	 * @var string
	 * @ORM\Column(name="base_path", type="string", nullable=false)
	 */
	public $basePath;

	/**
	 * @var Image[]
	 * @ORM\OneToMany(targetEntity="Image", mappedBy="album", indexBy="id")
	 */
	protected $images;

	protected $cover;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint")
	 */
	public $isPublished;

	/**
	 * @var AlbumText[]
	 *
	 * @ORM\OneToMany(targetEntity="AlbumText", mappedBy="album", indexBy="lang")
	 */
	public $texts;

	public function __construct($basePath)
	{
		$this->basePath    = $basePath;
		$this->isPublished = 1;
		$this->images      = new ArrayCollection();
		$this->texts       = new ArrayCollection();
	}

	public function setId($id)
	{
		$this->id = $id;
	}

	public function generatePath() { return $this->basePath . '/' . $this->getId() . ($this->title ? '-' . Strings::webalize($this->title) : ''); }

	public function getPath() { return $this->basePath . '/album_' . $this->getId(); }

	/**
	 * @return ArrayCollection|Image[];
	 */
	public function getImages()
	{
		$iterator = $this->images->getIterator();
		$iterator->uasort(function($a, $b) {
			return ($a->getPosition() < $b->getPosition()) ? -1 : 1;
		});

		return new ArrayCollection(iterator_to_array($iterator));
	}

	public function setCoverImage($img)
	{
		$this->cover = $img;
	}

	public function getCoverRaw() { return $this->cover; }

	/**
	 * @return Image|null
	 */
	public function getCoverImage()
	{
		if (!$this->cover) {
			if ($this->images) {
				foreach ($this->images->toArray() as $img) {
					if ($img->isCover) {
						$cover = $img;
						break;
					}
				}

				if (!isset($cover))
					$cover = $this->images->first();

				$this->cover = $cover;
			}
		}

		return $this->cover ?: null;
	}

	/**
	 * @return int
	 */
	public function getImagesCount()
	{
		return $this->images->count();
	}

	public function addImage($image)
	{
		$this->images->add($image);
	}

	/******
	 * === Texts
	 */

	/**
	 * @param AlbumText $texts
	 */
	public function addText($text)
	{
		if (!$this->texts->containsKey($text->getLang()))
			$this->texts->add($text);
	}

	/**
	 * @param string $lang
	 *
	 * @return AlbumText|null
	 */
	public function getText($lang = null)
	{
		return $this->texts->get($lang ?: $this->locale);
	}

	public function getTitle() { return $this->getText($this->locale)->title ?? $this->title; }

	public function getDescription() { return $this->getText($this->locale)->description ?? $this->description; }
}
