<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Gallery\Model\Albums;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Localization\ITranslator;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;

class AlbumListener implements EventSubscriberInterface
{
	use SmartObject;

	/** @var Cache */
	private $cache;

	/** @var ITranslator */
	protected $translator;

	public function __construct(IStorage $cacheStorage, ITranslator $translator)
	{
		$this->cache      = new Cache($cacheStorage, Albums::CACHE_NAMESPACE);
		$this->translator = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param Album              $album
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($album, $args)
	{
		if ($album->getId())
			$this->cache->clean([
				Cache::TAGS => ['album/' . $album->getId()],
			]);
		else {
			$this->cache->clean([
				Cache::TAGS => ['albums'],
			]);
		}
	}
}
