<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;
use Nette\Utils\DateTime;
use Nette\Utils\Json;
use Tags\Model\Entities\Tag;

/**
 * Class AlbumText
 * @package Gallery\Model\Entities
 *
 * @ORM\Table(name="gallery__album_text")
 * @ORM\Entity
 */
class AlbumText
{

	/**
	 * @var Album
	 *
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Album", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="album_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $album;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2)
	 */
	private $lang;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="text", nullable=true)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="description", type="text", nullable=true)
	 */
	public $description;

	/**
	 * AlbumText constructor.
	 *
	 * @param Album  $album
	 * @param string $lang
	 */
	public function __construct($album, $lang)
	{
		$this->album = $album;
		$this->lang  = $lang;
	}

	public function getAlbum() { return $this->album; }

	public function getLang() { return $this->lang; }
}
