<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Gallery\Model\Albums;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Localization\ITranslator;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;

class ImageTextListener implements EventSubscriberInterface
{
	use SmartObject;

	/** @var Cache */
	private $albumCache;

	/** @var ITranslator */
	protected $translator;

	public function __construct(IStorage $cacheStorage, ITranslator $translator)
	{
		$this->albumCache = new Cache($cacheStorage, Albums::CACHE_NAMESPACE);
		$this->translator = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param ImageText          $imageText
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($imageText, $args)
	{
		if ($imageText->getImage()->getAlbum()->getId())
			$this->albumCache->clean([
				Cache::TAGS => ['album/' . $imageText->getImage()->getAlbum()->getId()],
			]);
		else {
			$this->albumCache->clean([
				Cache::TAGS => ['albums'],
			]);
		}
	}
}
