<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Components\Album;

use Core\AdminModule\Components\ContentLangSwitcher\IContentLangSwitcherFactory;
use Core\Components\Flashes\Flashes;
use Core\Model\Images\TImagePipe;
use Core\Model\UI\BaseControl;
use Gallery\AdminModule\Model\Albums;

/**
 * TODO stránkování
 *
 * Class AlbumsList
 * @package Gallery\AdminModule\Components
 */
class AlbumsList extends BaseControl
{

	/** @var int */
	protected $page = 1;

	/** @var Albums */
	protected $albumsService;

	/** @var IContentLangSwitcherFactory */
	public $contentLangSwitcherFactory;

	public function __construct(Albums $albums, IContentLangSwitcherFactory $contentLangSwitcherFactory)
	{
		$this->albumsService              = $albums;
		$this->contentLangSwitcherFactory = $contentLangSwitcherFactory;
	}

	public function render()
	{
		$limit                        = 12;
		$this->template->page         = $this->page;
		$this->template->pagesCount   = ceil($this->albumsService->getCount() / $limit);
		$this->template->albums       = $this->albumsService->getAlbums($limit, ($this->page - 1) * $limit);
		$this->template->contentLangs = $this['contentLangSwitcher']->getLangs();
		$this->template->render(__DIR__ . '/AlbumsList.latte');
	}

	/*******************************************************************************************************************
	 * ========================  Handle
	 */

	public function handleDeleteAlbum($id)
	{
		$presenter = $this->getPresenter();
		$error     = false;

		try {
			if ($result = $this->albumsService->deleteAlbum($id)) {
				$presenter->flashMessage('gallery.album.deleteSuccess', Flashes::FLASH_SUCCESS);
			} else {
				$error = true;
			}
		} catch (\Exception $e) {
			$presenter->flashMessage($e->getMessage(), Flashes::FLASH_DANGER);
			$error = true;
		}

		if ($presenter->isAjax()) {
			$presenter->redrawControl('flashes');

			if (!$error)
				$this->redrawControl('albumsList');
		} else {
			$this->redirect('this');
		}
	}

	public function handlePage($page)
	{
		$this->page = $page;
	}

	/*******************************************************************************************************************
	 * ========================  Components
	 */

	protected function createComponentContentLangSwitcher()
	{
		$control               = $this->contentLangSwitcherFactory->create();
		$control->templateFile = 'Inline';
		$control->title        = $this->t('gallery.contentLanguage');

		return $control;
	}
}
