<?php declare(strict_types = 1);

namespace Gallery\FrontModule\Model\Dao;

use Core\Model\Providers\ISiteMapImage;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class Image
 * @package Gallery\FrontModule\Model\Dao
 */
class Image implements ISiteMapImage
{
	use MagicAccessors;

	/** @var int */
	public $id;

	/** @var string */
	public $title;

	/** @var string */
	public $description;

	/** @var string */
	public $source;

	/** @var string */
	protected $file;

	/** @var string */
	public $link;

	/** @var int */
	public $position;

	/** @var bool */
	public $isCover = false;

	public function setFile($file)
	{
		$this->file = str_replace('\\', '/', $file);

		return $this;
	}

	/**
	 * @return string
	 */
	public function getFilePath() { return $this->file; }

	/**
	 * @return string
	 */
	public function getCaption() { return $this->description; }

	/**
	 * @return string
	 */
	public function getTitle() { return $this->title; }

	/**
	 * @return string
	 */
	public function getGeoLocation() { return ''; }

	/**
	 * @return string
	 */
	public function getLicense() { return ''; }

}
