<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Components\Image;

use Core\Model\UI\BaseControl;
use Gallery\Model\Entities\Album;
use Gallery\Model\Entities\Image;
use Gallery\Model\Images;

class ImageFinder extends BaseControl
{
	/** @var callable[] */
	public array     $onUseImage  = [];
	protected ?Album $activeAlbum = null;

	public function __construct(protected Images $imagesService)
	{
	}

	public function render(): void
	{
		$this->template->activeImagesId = $this->activeAlbum ? array_map(static fn(Image $i,
		) => $i->getId(), $this->activeAlbum->getImages()->toArray()) : [];
		$this->template->render(__DIR__ . '/ImageFinder.latte');
	}

	/*******************************************************************************************************************
	 * =================  Handle
	 */

	public function handleSearch(string $q): void
	{
		$this->template->images = $this->imagesService->search($q);
		$this->redrawControl('results');
	}

	/*******************************************************************************************************************
	 * =================  Get / Set
	 */

	public function setActiveAlbum(Album $album): void
	{
		$this->activeAlbum = $album;
	}
}
