<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Components\Image;

use Core\Model\UI\BaseControl;
use Gallery\Model\Albums;
use Gallery\Model\Entities\Image;
use Gallery\Model\Images;

class ImagesPicker extends BaseControl
{
	/** @var Image[] */
	protected array $images;

	public function __construct(protected Images $imagesService, protected Albums $albumsService)
	{
	}

	public function render(): void
	{
		$this->template->images = $this->images;
		$this->template->render(__DIR__ . '/ImagesPicker.latte');
	}

	public function setByAlbum(int|string $id): void
	{
		$images = [];

		foreach ($this->imagesService->getByAlbum($id) as $image) {
			$images[] = $image;
		}

		$this->images = $images;
	}
}
