<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Presenters;

use Nette\Application\BadRequestException;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	/**
	 * @param mixed $element
	 *
	 * @throws BadRequestException
	 */
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);

		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access')) {
			$this->error();
		}
	}
}
