<?php declare(strict_types = 1);

namespace Gallery\Console;

use Doctrine;
use Exception;
use Gallery\Model\Cleaner;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Tracy\Debugger;

#[AsCommand(name: 'gallery:auto-resize-images')]
class AutoResize extends Command
{
	/** @var Cleaner @inject */
	public Cleaner $cleaner;

	protected function configure(): void
	{
		$this->setName('gallery:auto-resize-images');
	}

	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		ini_set('memory_limit', '4G');
		$output->writeln('Auto resize images');

		try {
			Debugger::dispatch();

			$this->cleaner->autoResizeGalleries();

			$output->writeLn('<info>[OK] - resized</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
