<?php declare(strict_types = 1);

namespace Gallery\Console;

use Doctrine;
use Exception;
use Gallery\Model\Cleaner;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Tracy\Debugger;

#[AsCommand(name: 'gallery:check-not-found-images')]
class CheckNotFoundImages extends Command
{
	/** @var Cleaner @inject */
	public Cleaner $cleaner;

	protected function configure(): void
	{
		$this->setName('gallery:check-not-found-images')
			->addOption('delete', null, InputOption::VALUE_OPTIONAL, '', 'false');
	}

	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		ini_set('memory_limit', '4G');
		$output->writeln('Check not found images');

		try {
			Debugger::dispatch();

			$list = $this->cleaner->checkNotFoundImages();

			foreach ($list as $row) {
				$output->writeln($row);
			}

			if ($list && $input->getOption('delete') === 'true') {
				$this->cleaner->removeImagesFromDB(array_keys($list));
			}

			$output->writeLn('<info>[OK] - checked</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
