<?php declare(strict_types = 1);

namespace Gallery\DI;

use Nette\PhpGenerator\ClassType;
use Core\DI\CompilerExtension;
use Nette;
use Override;

class GalleryExtension extends CompilerExtension
{
	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Gallery' => 'Gallery\*Module\Presenters\*Presenter']);
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');

		$init->addBody('Gallery\Model\GalleryConfig::setParams($this->parameters[\'gallery\']);');
	}

}
