<?php declare(strict_types = 1);

namespace Gallery\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Gallery\FrontModule\Model\Albums;
use Gallery\Model\Entities\Album;
use Gallery\Model\Images;
use Throwable;

class GalleryControl extends BaseControl
{
	protected ?Album $album        = null;
	public string    $templateFile = __DIR__ . '/default.latte';

	public function __construct(protected Images $imagesService, protected Albums $albumsService)
	{
	}

	public function render(): void
	{
		$this->template->album = $this->album;
		$this->template->render($this->getTemplateFile());
	}

	/**
	 * @throws Throwable
	 */
	public function setAlbum(string|int $id): self
	{
		/** @var Album|null $album */
		$album       = $this->albumsService->get($id);
		$this->album = $album;

		return $this;
	}

}
