<?php declare(strict_types = 1);

namespace Gallery\FrontModule\Model\Dao;

use Closure;

class Album
{
	/** @var int */
	public $id;

	/** @var string */
	public $title;

	/** @var string */
	public $description;

	/** @var Image[] */
	public $images;

	/** @var Image|null */
	public $cover;

	public ?Image $defaultCover = null;

	/** @var Closure|null */
	public ?Closure $placeholderCallback = null;

	/**
	 * @param Image[] $images
	 *
	 * @return $this
	 */
	public function setImages(array $images): self
	{
		$this->images = [];
		foreach ($images as $img) {
			/** @phpstan-ignore-next-line */
			if ($img instanceof Image) {
				$this->images[$img->id] = $img;
			}
		}

		return $this;
	}

	public function addImage(Image $image): self
	{
		$this->images[] = $image;

		return $this;
	}

	public function getCover(): ?Image { return $this->cover; }

	public function setCover(Image $img): self
	{
		$this->cover = $img;

		return $this;
	}

	/**
	 * @return Image[]
	 */
	public function getImages()
	{
		return $this->images;
	}
}
