<?php declare(strict_types = 1);

namespace Gallery\FrontModule\Presenters;

use Doctrine\Common\Collections\Criteria;
use Exception;
use Gallery\Model\Albums;
use Gallery\Model\Images;

final class DefaultPresenter extends BasePresenter
{
	public function __construct(protected Albums $albumsService, protected Images $imagesService)
	{
		parent::__construct();
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */
	/**
	 * @throws Exception
	 */
	public function actionDetail(int|string $album, int|string|null $image = null): void
	{
		$album    = $this->albumsService->getAlbum($album);
		$isMobile = $this->getHttpRequest()->getQuery('mobile') == '1';

		if ($image) {
			$image = $this->imagesService->getImage($image);
		} else if ($album) {
			$this->redirect('this', [$album->getId(),
				$album->getImages()->matching(Criteria::create()->where(Criteria::expr()->eq('isCover', 0)))->first()
					->getId(),
			]);
		}

		if (!$album || !$image) {
			$this->error();
		}

		$this->setLayout(__DIR__ . '/templates/Default/@layout.latte');
		$this['title']->setTitle($this->translator->translate('gallery.title.gallery') . ' - ' . $album->title);

		$this->template->album  = $album;
		$this->template->image  = $image;
		$this->template->isAjax = $this->isAjax();


		if (!$isMobile) {
			if ($this->isAjax()) {
				$this->template->render(__DIR__ . '/templates/Default/detailAjax.latte');
				$this->terminate();
			}
		} else {
			if ($this->isAjax()) {
				$this->template->render(__DIR__ . '/templates/Default/detailMobileAjax.latte');
				$this->terminate();
			}
			$this->template->render(__DIR__ . '/templates/Default/detailMobile.latte');
		}
	}

}
