<?php declare(strict_types = 1);

namespace Gallery\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20180801010107 extends AbstractMigration
{
	public function up(Schema $schema): void
	{

		$this->addSql(
			'CREATE TABLE gallery__album (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) DEFAULT NULL, description LONGTEXT DEFAULT NULL, base_path VARCHAR(255) NOT NULL, is_published SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE gallery__image (id INT AUTO_INCREMENT NOT NULL, album_id INT DEFAULT NULL, clone_of_id INT DEFAULT NULL, source VARCHAR(255) DEFAULT NULL, title LONGTEXT DEFAULT NULL, description LONGTEXT DEFAULT NULL, link LONGTEXT DEFAULT NULL, filename VARCHAR(255) NOT NULL, path VARCHAR(255) DEFAULT NULL, position INT NOT NULL, is_published SMALLINT NOT NULL, is_cover SMALLINT NOT NULL, thumb_coords LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', last_use DATETIME DEFAULT NULL, INDEX IDX_C53D045F1137ABCF (album_id), INDEX IDX_C53D045F97A8D4D6 (clone_of_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE gallery__image_tags (image_id INT NOT NULL, tag_id INT NOT NULL, INDEX IDX_9D867EB83DA5256D (image_id), INDEX IDX_9D867EB8BAD26311 (tag_id), PRIMARY KEY(image_id, tag_id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB',
		);

		$this->addSql(
			'ALTER TABLE gallery__image ADD CONSTRAINT FK_C53D045F1137ABCF FOREIGN KEY (album_id) REFERENCES gallery__album (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE gallery__image ADD CONSTRAINT FK_C53D045F97A8D4D6 FOREIGN KEY (clone_of_id) REFERENCES gallery__image (id) ON DELETE SET NULL',
		);
		$this->addSql(
			'ALTER TABLE gallery__image_tags ADD CONSTRAINT FK_9D867EB83DA5256D FOREIGN KEY (image_id) REFERENCES gallery__image (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE gallery__image_tags ADD CONSTRAINT FK_9D867EB8BAD26311 FOREIGN KEY (tag_id) REFERENCES tag (id) ON DELETE CASCADE',
		);
	}

	public function down(Schema $schema): void
	{

		$this->addSql('ALTER TABLE gallery__image DROP FOREIGN KEY FK_C53D045F97A8D4D6');
		$this->addSql('ALTER TABLE gallery__image_tags DROP FOREIGN KEY FK_9D867EB83DA5256D');

		$this->addSql('DROP TABLE gallery__album');
		$this->addSql('DROP TABLE gallery__image');
		$this->addSql('DROP TABLE gallery__image_tags');
	}
}
