<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Gallery\Model\Albums;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class AlbumListener implements EventSubscriberInterface
{
	use SmartObject;

	protected readonly Cache $cache;

	public function __construct(
		protected Storage    $cacheStorage,
		protected Translator $translator,
	)
	{
		$this->cache = new Cache($cacheStorage, Albums::CACHE_NAMESPACE);
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreFlush]
	public function onPreFlush(Album $album, PreFlushEventArgs $args): void
	{
		$this->clearCache($album);
	}

	#[ORM\PostUpdate]
	#[ORM\PostRemove]
	public function postHandler(Album $album, LifecycleEventArgs $event): void
	{
		$this->clearCache($album);
	}

	protected function clearCache(Album $album): void
	{
		if ($album->getId()) {
			foreach ($this->translator->getLocalesWhitelist() ?: [] as $lang) {
				$this->cache->remove('album/' . $lang . '/' . $album->getId());
			}

			$this->cache->clean([
				Cache::Tags => ['album/' . $album->getId()],
			]);
		} else {
			$this->cache->clean([
				Cache::Tags => ['albums'],
			]);
		}
	}
}
