<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'gallery__album_text')]
#[ORM\Entity]
class AlbumText
{

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $title = null;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $description = null;

	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Album::class, cascade: ['persist', 'remove'], inversedBy: 'texts')]
	#[ORM\JoinColumn(name: 'album_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	protected ?Album $album;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2)]
	protected string $lang;

	public function __construct(Album $album, string $lang)
	{
		$this->album = $album;
		$this->lang  = $lang;
	}

	public function __clone()
	{
		$this->album = null;
	}

	public function setAlbum(Album $album): void { $this->album = $album; }

	public function getAlbum(): Album { return $this->album; }

	public function getLang(): string { return $this->lang; }
}
