<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Gallery\Model\Albums;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ImageTextListener implements EventSubscriberInterface
{
	use SmartObject;

	protected readonly Cache $albumCache;

	public function __construct(
		protected Storage    $cacheStorage,
		protected Translator $translator,
	)
	{
		$this->albumCache = new Cache($cacheStorage, Albums::CACHE_NAMESPACE);
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreFlush]
	public function onPreFlush(ImageText $imageText, PreFlushEventArgs $args): void
	{
		$this->clearCache($imageText);
	}

	#[ORM\PostUpdate]
	#[ORM\PostRemove]
	public function postHandler(ImageText $imageText, LifecycleEventArgs $event): void
	{
		$this->clearCache($imageText);
	}

	protected function clearCache(ImageText $imageText): void
	{
		if ($imageText->getImage()->getAlbum() && $imageText->getImage()->getAlbum()->getId()) {
			$albumId = $imageText->getImage()->getAlbum()->getId();

			foreach ($this->translator->getLocalesWhitelist() ?: [] as $lang) {
				$this->albumCache->remove('album/' . $lang . '/' . $albumId);
			}

			$this->albumCache->clean([
				Cache::Tags => ['album/' . $albumId],
			]);
		} else {
			$this->albumCache->clean([
				Cache::Tags => ['albums'],
			]);
		}
	}
}
