<?php declare(strict_types = 1);

namespace Gallery\Model\Subscribers;

use Core\Model\Event\TemplateFactoryEvent;
use Gallery\FrontModule\Model\Albums;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TemplateSubscriber implements EventSubscriberInterface
{
	public function __construct(protected Albums $albums)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'templateFactory::createTemplate' => 'createTemplate',
		];
	}

	public function createTemplate(TemplateFactoryEvent $event): void
	{
		$event->template->galleriesService = $this->albums;
	}
}
