<?php declare(strict_types = 1);

namespace Gallery\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Gallery\FrontModule\Model\Albums;

class Gallery extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'gallery';

	public function __construct(protected Albums $albumsService)
	{
	}

	/**
	 * @inheritdoc
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$formContainer->addGalleryPopup($this->getName(), $this->getTitle());
	}

	public function render(array $params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->getDefault() ? $this->albumsService->get((int) $this->getDefault()) : null;
	}
}
