<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Presenters;

use Gallery\AdminModule\Components\Image\IImagesZoneFactory;
use Gallery\AdminModule\Components\Image\ImagesZone;
use Gallery\Model\Entities\Album;
use Nette\Utils\Html;

final class AlbumPresenter extends BasePresenter
{
	/** @var string|null @persistent */
	public ?string $htmlId = null;

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionPopup(?int $id = null): void
	{
		$imagesZone = $this['imagesZone'];

		if ($id) {
			$imagesZone->setAlbum($id);
		}

		$this->getTemplate()->modal            = 'album';
		$this->getTemplate()->modalDialogClass = 'modal-full';

		ob_start();
		$imagesZone->render();
		$body = ob_get_clean();

		$this->getTemplate()->modalBody = Html::el()->addHtml($body);
		$this->redrawControl('modal');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */


	protected function createComponentImagesZone(IImagesZoneFactory $factory): ImagesZone
	{
		$control = $factory->create();

		$control->onEmpty[] = function(ImagesZone $control) {
			if (!$control->getAlbum()) {
				$album = new Album(UPLOADS_PATH . '/template_pages/page_gallery');

				$album->title = (string) $this->getParameter('id');

				$this->em->persist($album);
				$this->em->flush();

				$control->setAlbum($album->getId());

				$htmlId = $this->getParameter('htmlId');

				if ($htmlId) {
					$control->extendedResponseOnEmpty['setAttributeByHtmlId'][$htmlId]['value'] = $album->getId();
					$control->extendedResponse['setAttributeByHtmlId'][$htmlId]['value']        = $album->getId();

					$params = array_merge($this->getParameters(), ['id' => $album->getId()]);
					unset($params['do']);

					$link = $this->link('popup', $params);

					$control->extendedResponseOnEmpty['setAttributeByHtmlId'][$htmlId . 'GalleryLink']['href'] = $link;
					$control->extendedResponse['setAttributeByHtmlId'][$htmlId . 'GalleryLink']['href']        = $link;
				}
			}
		};

		return $control;
	}
}
