<?php declare(strict_types = 1);

namespace Gallery\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use Exception;
use Gallery\AdminModule\Components\Album\AlbumForm;
use Gallery\AdminModule\Components\Album\AlbumsList;
use Gallery\AdminModule\Components\Album\IAlbumFormFactory;
use Gallery\AdminModule\Components\Album\IAlbumsListFactory;
use Gallery\AdminModule\Model\Albums;
use Nette\Utils\Html;

final class DefaultPresenter extends BasePresenter
{
	/** @var Albums @inject */
	public Albums $albumsService;

	protected function startup(): void
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('gallery.title.gallery'));
		$this->setHeader('gallery.title.gallery', 'fa fa-image');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'gallery.menu.newGallery',
				'link'  => 'Default:add',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAdd(): void
	{
		$this->setTitle($this->translator->translate('gallery.title.newGallery'));
		$this->setHeader('gallery.title.newGallery', 'fa fa-image');
	}

	/**
	 * @param int|string $id
	 * @throws Exception
	 */
	public function actionEdit($id): void
	{
		$album = $this->albumsService->getAlbum($id);

		if (!$album) {
			$this->error();
		}

		$this->setTitle($this->translator->translate('gallery.title.editGallery') . ': ' . Html::el('span class=font-weight-light')->setText($album->getText()->title));
		$this->setHeader('gallery.title.editGallery', 'fa fa-image');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentAlbumForm(IAlbumFormFactory $factory): AlbumForm
	{
		$control = $factory->create();

		if ($this->getParameter('id')) {
			$control->setAlbum($this->getParameter('id'));
		}

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('edit', $form->getCustomData('albumId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentAlbumsList(IAlbumsListFactory $factory): AlbumsList
	{
		return $factory->create();
	}
}
