<?php declare(strict_types = 1);

namespace Gallery\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Gallery\FrontModule\Model\Albums;
use Gallery\Model\Entities\Album;
use Gallery\Model\Images;
use Throwable;

class GalleryControl extends BaseControl
{
	protected Images $imagesService;
	protected Albums $albumsService;
	protected ?Album $album = null;
	public string $templateFile = __DIR__ . '/default.latte';

	public function __construct(Images $images, Albums $albums)
	{
		$this->imagesService = $images;
		$this->albumsService = $albums;
	}

	public function render(): void
	{
		$this->template->album = $this->album;
		$this->template->render($this->getTemplateFile());
	}

	/**
	 * @param string|int $id
	 * @throws Throwable
	 */
	public function setAlbum($id): self
	{
		/** @var Album|null $album */
		$album = $this->albumsService->get($id);
		$this->album = $album;

		return $this;
	}

}
