<?php declare(strict_types = 1);

namespace Gallery\FrontModule\Model\Dao;

use Core\Model\Providers\ISiteMapImage;

class Image implements ISiteMapImage
{
	/** @var bool|int */
	public         $isCover     = false;
	public int     $id;
	public ?string $title       = null;
	public ?string $description = null;
	public ?string $alt         = null;
	public ?string $source      = null;
	public ?string $file        = null;
	public ?string $link        = null;
	public int     $position    = 0;
	public ?array  $thumbCoords = [];
	public ?Album  $album       = null;
	public ?int    $albumId     = null;

	public function setFile(string $file): self
	{
		$this->file = str_replace('\\', '/', $file);

		return $this;
	}

	public function getFilePath(): ?string
	{
		if ($this->file) {
			return $this->file;
		}

		if ($this->album && $this->album->placeholderCallback) {
			$data = call_user_func($this->album->placeholderCallback);

			if (isset($data['file'])) {
				return $data['file'];
			}
		}

		return null;
	}

	public function getCaption(): ?string { return $this->description; }

	public function getTitle(): ?string
	{
		if ($this->title) {
			return $this->title;
		}

		if ($this->album && $this->album->placeholderCallback) {
			$data = call_user_func($this->album->placeholderCallback);

			if (isset($data['title'])) {
				return $data['title'];
			}
		}

		return null;
	}

	public function getAlt(): ?string
	{
		if ($this->alt) {
			return $this->alt;
		}

		if ($this->album && $this->album->placeholderCallback) {
			$data = call_user_func($this->album->placeholderCallback);

			if (isset($data['alt'])) {
				return $data['alt'];
			}
		}

		return null;
	}

	public function getGeoLocation(): string { return ''; }

	public function getLicense(): string { return ''; }

	public function getFullDescription(): ?string
	{
		$str = '';
		if ($this->title) {
			$str .= '<b>' . $this->title . '</b>';
		}

		if ($this->description) {
			$str .= '<br>' . nl2br($this->description);
		}

		return $str ?: null;
	}

}
