<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="gallery__image_text")
 * @ORM\Entity
 * @ORM\EntityListeners({"ImageTextListener"})
 */
class ImageText
{
	/**
	 * @var Image|null
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Image", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="image_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $image;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2)
	 */
	private string $lang;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $source = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $title = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $alt = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $description = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $link = null;

	public function __construct(Image $image, string $lang)
	{
		$this->image = $image;
		$this->lang  = $lang;
	}

	public function __clone()
	{
		$this->image = null;
	}

	public function setImage(Image $image): void { $this->image = $image; }

	public function getImage(): Image { return $this->image; }

	public function getLang(): string { return $this->lang; }
}
