<?php declare(strict_types = 1);

namespace Gallery\Model\Entities;

use Contributte\Translation\Translator;
use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Gallery\Model\Albums;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ImageTextListener implements EventSubscriberInterface
{
	use SmartObject;

	private Cache        $albumCache;
	protected Translator $translator;

	public function __construct(IStorage $cacheStorage, Translator $translator)
	{
		$this->albumCache = new Cache($cacheStorage, Albums::CACHE_NAMESPACE);
		$this->translator = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 */
	public function onPreFlush(ImageText $imageText, PreFlushEventArgs $args): void
	{
		$this->clearCache($imageText);
	}

	/**
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 */
	public function postHandler(ImageText $imageText, LifecycleEventArgs $event): void
	{
		$this->clearCache($imageText);
	}

	protected function clearCache(ImageText $imageText): void
	{
		$image = $imageText->getImage();

		if ($image->getAlbum() && $image->getAlbum()->getId()) {
			$albumId = $image->getAlbum()->getId();

			foreach ($this->translator->getLocalesWhitelist() ?: [] as $lang) {
				$this->albumCache->remove('album/' . $lang . '/' . $albumId);
			}

			$this->albumCache->clean([
				Cache::TAGS => ['album/' . $albumId],
			]);
		} else {
			$this->albumCache->clean([
				Cache::TAGS => ['albums'],
			]);
		}
	}
}
